program intrinsics_196
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    real(8) :: x(40)
    real(8) :: expected(40)
  
    real :: y(30)
    real :: expected_y(30)
  
    integer :: i

    real(dp), parameter :: res(40) = bessel_j1([3.3398640543782485_dp, 5.039184326269492_dp, 6.738504598160736_dp, &
    8.43782487005198_dp, 10.137145141943222_dp, 11.836465413834466_dp, 13.53578568572571_dp, 15.235105957616954_dp, &
    16.934426229508198_dp, 18.63374650139944_dp, 1.999201299880048d+306, 1.199520279928029d+307, &
    2.1991204298680527d+307, 3.198720579808077d+307, 4.198320729748101d+307, 5.197920879688125d+307, &
    6.197521029628149d+307, 7.197121179568173d+307, 8.196721329508197d+307, 9.196321479448221d+307, &
    -0.8439824070371851_dp, -1.0638944422231107_dp, -1.2838064774090363_dp, -1.503718512594962_dp, &
    -1.7236305477808875_dp, -1.9435425829668134_dp, -2.163454618152739_dp, -2.3833666533386646_dp, &
    -2.60327868852459_dp, -2.823190723710516_dp, .8439824070371851_dp, 1.0638944422231107_dp, &
    1.2838064774090363_dp, 1.503718512594962_dp, 1.7236305477808875_dp, 1.9435425829668134_dp, &
    2.163454618152739_dp, 2.3833666533386646_dp, 2.60327868852459_dp, 2.823190723710516_dp])
  
    x = [3.3398640543782485_dp, 5.039184326269492_dp, 6.738504598160736_dp, 8.43782487005198_dp, &
    10.137145141943222_dp, 11.836465413834466_dp, 13.53578568572571_dp, 15.235105957616954_dp, &
    16.934426229508198_dp, 18.63374650139944_dp, 1.999201299880048d+306, 1.199520279928029d+307, &
    2.1991204298680527d+307, 3.198720579808077d+307, 4.198320729748101d+307, 5.197920879688125d+307, &
    6.197521029628149d+307, 7.197121179568173d+307, 8.196721329508197d+307, 9.196321479448221d+307, &
    -0.8439824070371851_dp, -1.0638944422231107_dp, -1.2838064774090363_dp, -1.503718512594962_dp, &
    -1.7236305477808875_dp, -1.9435425829668134_dp, -2.163454618152739_dp, -2.3833666533386646_dp, &
    -2.60327868852459_dp, -2.823190723710516_dp, .8439824070371851_dp, 1.0638944422231107_dp, &
    1.2838064774090363_dp, 1.503718512594962_dp, 1.7236305477808875_dp, 1.9435425829668134_dp, &
    2.163454618152739_dp, 2.3833666533386646_dp, 2.60327868852459_dp, 2.823190723710516_dp]
  
    expected = [0.20421621687655644_dp, -0.33171193864355270_dp, -8.3784683987487160E-002_dp, 0.27198866581429970_dp, &
    9.0842803254412019E-003_dp, -0.23134340809868278_dp, 4.5606105201175973E-002_dp, 0.19306664290638995_dp, &
    -8.6684684328497116E-002_dp, -0.15370371403787708_dp, 1.2435438521419326E-155_dp, -2.8314187014586877E-155_dp, &
    -1.5668960835696801E-154_dp, -1.2962049361081139E-154_dp, 1.2232544148395820E-154_dp, -8.9027017266527920E-155_dp, &
    7.4652062949806537E-156_dp, 1.0051338573860275E-155_dp, 7.9153155792012788E-155_dp, 7.0791696617318761E-155_dp, &
    -0.38551658341791684_dp, -0.46015216947899512_dp, -0.51843459851029450_dp, -0.55845382793597553_dp, -0.57902364849354149_dp, &
    -0.57972422117951550_dp, -0.56091267269977430_dp, -0.52370145724258965_dp, -0.46990557508027103_dp, -0.40196106888470001_dp, &
    0.38551658341791684_dp, 0.46015216947899512_dp, 0.51843459851029450_dp, 0.55845382793597553_dp, 0.57902364849354149_dp, &
    0.57972422117951550_dp, 0.56091267269977430_dp, 0.52370145724258965_dp, 0.46990557508027103_dp, 0.40196106888470001_dp]
  
    do i = 1, size(x)
        print *, bessel_j1(x(i)), "i = ", i
        if (abs(bessel_j1(x(i)) - expected(i)) > 1e-12) error stop
    end do

    do i = 1, size(res)
        print *, res(i)
        if (abs(res(i) - expected(i)) > 1e-12_dp) error stop
  end do
  
    y = [3.3398640543782485_sp, 5.039184326269492_sp, 6.738504598160736_sp, 8.43782487005198_sp, &
    10.137145141943222_sp, 11.836465413834466_sp, 13.53578568572571_sp, 15.235105957616954_sp, &
    16.934426229508198_sp, 18.63374650139944_sp, &
    -0.8439824070371851_sp, -1.0638944422231107_sp, -1.2838064774090363_sp, -1.503718512594962_sp, &
    -1.7236305477808875_sp, -1.9435425829668134_sp, -2.163454618152739_sp, -2.3833666533386646_sp, &
    -2.60327868852459_sp, -2.823190723710516_sp, .8439824070371851_sp, 1.0638944422231107_sp, &
    1.2838064774090363_sp, 1.503718512594962_sp, 1.7236305477808875_sp, 1.9435425829668134_sp, &
    2.163454618152739_sp, 2.3833666533386646_sp, 2.60327868852459_sp, 2.823190723710516_sp]
    
    expected_y = [0.204216227_sp, -0.331711948_sp, -8.37847441E-02_sp, 0.271988720_sp, &
    9.08430573E-03_sp, -0.231343403_sp, 4.56061028E-02_sp, 0.193066686_sp, &
    -8.66845325E-02_sp, -0.153703660_sp, -0.385516584_sp, -0.460152149_sp, &
    -0.518434584_sp, -0.558453798_sp, -0.579023659_sp, -0.579724193_sp, &
    -0.560912728_sp, -0.523701489_sp, -0.469905645_sp, -0.401961178_sp, &
    0.385516584_sp, 0.460152149_sp, 0.518434584_sp, 0.558453798_sp, &
    0.579023659_sp, 0.579724193_sp, 0.560912728_sp, 0.523701489_sp, &
    0.469905645_sp, 0.401961178_sp]
  
    do i = 1, size(y)
        print *, bessel_j1(y(i)), "i = ", i
        if (abs(bessel_j1(y(i)) - expected_y(i)) > 1e-6) error stop
    end do
  end program
